<?php

namespace App\Http\Controllers;


use App\Models\Preces;
use Illuminate\Http\Request;
use Symfony\Component\VarDumper\Cloner\Data;
use Yajra\DataTables\Facades\DataTables;

class PrecesController extends Controller

{
    public function index(Request $request){
        $Datis = Preces::all();

        return view('welcome', ['Preces' => $Datis]);
    }

    public function ajaxDati(Request $request){
        $Datis = Preces::query();

        return DataTables::eloquent($Datis)
            ->toJson();
    }

    public function ajaxPost(Request $request) {
        $updating = $request->id !== null;
        $success = true;
        $message = "";

        if (!$updating) {
            $Dati = new Preces();
            $Dati->create($request->all());
        } else {
            $Dati = Preces::find($request->id);
            $Dati->update($request->all());
            $Dati->save();
        }

        return [
            'success' => $success,
            'message' => $message,

        ];
    }

    public function ajaxDestroy(Request $request)
    {
        $success = true;
        $message = "";

        $Dati = Preces::find($request->id);
        $Dati->delete();

        return [
            'success' => $success,
            'message' => $message,


        ];
    }
}



